/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.util;

import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.api.PiglinNameManager;
import io.github.overlordsiii.villagernames.api.RaiderNameManager;
import io.github.overlordsiii.villagernames.api.VillagerNameManager;
import io.github.overlordsiii.villagernames.api.ZombieVillagerNameManager;
import io.github.overlordsiii.villagernames.config.NamesConfig;
import io.github.overlordsiii.villagernames.integration.cca.IntComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1439;
import net.minecraft.class_1584;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import net.minecraft.class_3852;
import net.minecraft.class_3989;
import net.minecraft.class_5418;

public class VillagerUtil {
    private static final ArrayList<String> usedUpNames = new ArrayList();
    private static final Random random = new Random();

    private static String upperFirstLetter(String string) {
        if (string.contains(":")) {
            string = string.substring(string.indexOf(":") + 1);
        }
        if (string.contains("_")) {
            string = string.substring(string.indexOf("_") + 1);
        }
        StringBuilder builder = new StringBuilder(string);
        builder.setCharAt(0, Character.toUpperCase(string.charAt(0)));
        return builder.toString();
    }

    private static String pickRandomName(NamesConfig namesConfig) {
        List<String> names = namesConfig.getNameList();
        int index = random.nextInt(names.size());
        if (usedUpNames.size() > names.size() / 2) {
            usedUpNames.clear();
        }
        if (usedUpNames.contains(names.get(index))) {
            index = random.nextInt(names.size());
        }
        usedUpNames.add(names.get(index));
        return names.get(index);
    }

    private static String generateWanderingTraderName() {
        if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
            if (VillagerNames.CONFIG.villagerGeneralConfig.reverseLastNames) {
                return VillagerUtil.generateRandomSurname() + VillagerUtil.pickRandomName(VillagerNames.CONFIG.villagerNamesConfig);
            }
            return VillagerUtil.pickRandomName(VillagerNames.CONFIG.villagerNamesConfig) + VillagerUtil.generateRandomSurname();
        }
        return VillagerUtil.pickRandomName(VillagerNames.CONFIG.villagerNamesConfig);
    }

    private static String generateRandomGolemName() {
        return VillagerUtil.pickRandomName(VillagerNames.CONFIG.golemNamesConfig);
    }

    private static String generateRandomSurname() {
        return VillagerUtil.pickRandomName(VillagerNames.CONFIG.sureNamesConfig);
    }

    public static void createPiglinNames(class_5418 entity) {
        if (!entity.method_16914()) {
            PiglinNameManager.setFirstName(VillagerUtil.pickRandomName(VillagerNames.CONFIG.piglinNamesConfig), entity);
            if (VillagerNames.CONFIG.villagerGeneralConfig.piglinSurnames) {
                PiglinNameManager.setLastName(VillagerUtil.pickRandomName(VillagerNames.CONFIG.piglinSurnamesConfig), entity);
            }
            entity.method_5665(PiglinNameManager.getFullNameAsText(entity, true));
        }
        entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
    }

    public static void createRavagerNames(class_3218 world, class_1584 entity) {
        if (!entity.method_16914()) {
            int counter = ((IntComponent)VillagerNames.INT_COMPONENT.get((Object)world.method_8401())).getValue() + 1;
            entity.method_5665((class_2561)new class_2585("Test Subject " + counter).method_27692(VillagerNames.CONFIG.villagerGeneralConfig.villagerTextFormatting.getFormatting()));
            ((IntComponent)VillagerNames.INT_COMPONENT.get((Object)world.method_8401())).setValue(counter);
        }
    }

    public static void createVillagerNames(class_1646 entity) {
        if (!entity.method_16914()) {
            VillagerNameManager.setFirstName(entity, VillagerUtil.pickRandomName(VillagerNames.CONFIG.villagerNamesConfig));
            if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
                VillagerNameManager.setLastName(entity, VillagerUtil.generateRandomSurname());
            }
            if (entity.method_7231().method_16924() != class_3852.field_17051 && VillagerNames.CONFIG.villagerGeneralConfig.professionNames) {
                VillagerNameManager.setProfessionName(class_3852.field_17062 == entity.method_7231().method_16924() ? VillagerNames.CONFIG.villagerGeneralConfig.nitwitText : VillagerUtil.upperFirstLetter(entity.method_7231().method_16924().toString()), entity);
                entity.method_5665(VillagerNameManager.getFullNameAsText(entity, true));
                entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
            } else {
                entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
                entity.method_5665(VillagerNameManager.getFullNameAsText(entity, true));
            }
        }
        entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
    }

    public static void createIllagerNames(class_3763 entity) {
        if (!entity.method_16914()) {
            RaiderNameManager.setFirstName(entity, VillagerUtil.pickRandomName(VillagerNames.CONFIG.villagerNamesConfig));
            if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
                RaiderNameManager.setLastName(entity, VillagerUtil.generateRandomSurname());
            }
            entity.method_5665(RaiderNameManager.getFullNameAsText(entity, true));
        }
        entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
    }

    public static void loadGolemNames(class_1439 entity) {
        if (!entity.method_16914() && VillagerNames.CONFIG.villagerGeneralConfig.golemNames) {
            String name = VillagerUtil.generateRandomGolemName();
            entity.method_5665((class_2561)new class_2585(name).method_27692(VillagerNames.CONFIG.villagerGeneralConfig.villagerTextFormatting.getFormatting()));
            entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
        }
    }

    public static void addProfessionName(class_1646 entity) {
        VillagerUtil.generalVillagerUpdate(entity);
        if (VillagerNameManager.getProfessionName(entity) == null && VillagerNames.CONFIG.villagerGeneralConfig.professionNames) {
            VillagerNameManager.setProfessionName(VillagerUtil.upperFirstLetter(entity.method_7231().method_16924().toString()), entity);
        }
        entity.method_5665(VillagerNameManager.getFullNameAsText(entity, true));
        entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
    }

    public static void updateLostVillagerProfessionName(class_1646 entity) {
        if (entity.method_16914() && VillagerNameManager.getProfessionName(entity) != null) {
            VillagerNameManager.setProfessionName(null, entity);
            entity.method_5665(VillagerNameManager.getFullNameAsText(entity, true));
        }
    }

    public static void updateGrownUpVillagerName(class_1646 entity) {
        if (entity.method_16914()) {
            VillagerUtil.generalVillagerUpdate(entity);
            VillagerNameManager.updateFullName(entity);
            entity.method_5665(VillagerNameManager.getFullNameAsText(entity, true));
        }
    }

    public static void addZombieVillagerName(class_1646 villagerEntity, class_1641 zombieVillagerEntity) {
        if (villagerEntity.method_16914()) {
            String firstName = VillagerNameManager.getFirstName(villagerEntity);
            ZombieVillagerNameManager.setFirstName(firstName, zombieVillagerEntity);
            if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
                ZombieVillagerNameManager.setLastName(VillagerNameManager.getLastName(villagerEntity), zombieVillagerEntity);
            }
            zombieVillagerEntity.method_5665((class_2561)new class_2585(ZombieVillagerNameManager.getFullNameWithZombie(zombieVillagerEntity)).method_27692(VillagerNames.CONFIG.villagerGeneralConfig.villagerTextFormatting.getFormatting()));
        }
    }

    public static void removeZombieVillagerName(class_1646 villagerEntity, class_1641 zombieVillagerEntity) {
        if (zombieVillagerEntity.method_16914()) {
            if (ZombieVillagerNameManager.getFirstName(zombieVillagerEntity) == null) {
                String[] components = zombieVillagerEntity.method_5797().method_10851().split("\\s+");
                String firstNameParsed = components[0];
                String lastNameParsed = null;
                if (VillagerNames.CONFIG.villagerGeneralConfig.surNames && components.length > 1) {
                    lastNameParsed = components[1];
                }
                ZombieVillagerNameManager.setFirstName(firstNameParsed, zombieVillagerEntity);
                ZombieVillagerNameManager.setLastName(lastNameParsed == null ? VillagerUtil.generateRandomSurname() : lastNameParsed, zombieVillagerEntity);
            }
            String firstName = ZombieVillagerNameManager.getFirstName(zombieVillagerEntity);
            if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
                VillagerNameManager.setLastName(villagerEntity, ZombieVillagerNameManager.getLastName(zombieVillagerEntity));
            }
            VillagerNameManager.setFirstName(villagerEntity, firstName);
            villagerEntity.method_5665(VillagerNameManager.getFullNameAsText(villagerEntity, true));
        }
    }

    public static void updatePiglinNames(class_5418 entity) {
        if (PiglinNameManager.getFirstName(entity) == null && VillagerNames.CONFIG.villagerGeneralConfig.piglinNames) {
            PiglinNameManager.setFirstName(VillagerUtil.pickRandomName(VillagerNames.CONFIG.piglinNamesConfig), entity);
        }
        if (VillagerNames.CONFIG.villagerGeneralConfig.piglinSurnames) {
            if (PiglinNameManager.getLastName(entity) == null) {
                PiglinNameManager.setLastName(VillagerUtil.pickRandomName(VillagerNames.CONFIG.piglinSurnamesConfig), entity);
            }
        } else if (PiglinNameManager.getLastName(entity) != null) {
            PiglinNameManager.setLastName(null, entity);
        }
        entity.method_5665(PiglinNameManager.getFullNameAsText(entity, true));
    }

    public static void updateIllagerNames(class_3763 entity) {
        if (RaiderNameManager.getFirstName(entity) == null && VillagerNames.CONFIG.villagerGeneralConfig.illagerEntityNames) {
            RaiderNameManager.setFirstName(entity, VillagerUtil.pickRandomName(VillagerNames.CONFIG.villagerNamesConfig));
        }
        if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
            if (RaiderNameManager.getLastName(entity) == null) {
                RaiderNameManager.setLastName(entity, VillagerUtil.generateRandomSurname());
            }
        } else if (RaiderNameManager.getLastName(entity) != null) {
            RaiderNameManager.setLastName(entity, null);
        }
        if (!VillagerNames.CONFIG.villagerGeneralConfig.professionNames) {
            if (RaiderNameManager.getTitle(entity) != null) {
                RaiderNameManager.setTitle(entity, null);
            }
        } else if (entity.method_16482() && entity.method_16219()) {
            RaiderNameManager.setTitle(entity, "Raid Captain");
        } else if (RaiderNameManager.getTitle(entity) == null) {
            RaiderNameManager.setTitle(entity, RaiderNameManager.getDefaultTitle(entity));
        }
        entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
        entity.method_5665(RaiderNameManager.getFullNameAsText(entity, true));
    }

    public static void generalVillagerUpdate(class_1646 entity) {
        if (entity.method_16914()) {
            if (VillagerNameManager.getFirstName(entity) == null) {
                String[] nameComponents = entity.method_5797().method_10851().split("\\s+");
                if (nameComponents.length == 0) {
                    return;
                }
                String firstName = nameComponents[0];
                String lastName = null;
                String professionName = null;
                if (VillagerNames.CONFIG.villagerGeneralConfig.surNames && nameComponents.length >= 2) {
                    if (VillagerNames.CONFIG.villagerGeneralConfig.reverseLastNames) {
                        firstName = nameComponents[1];
                        lastName = nameComponents[0];
                    } else {
                        lastName = nameComponents[1];
                    }
                }
                if (nameComponents.length >= 4 && !nameComponents[3].toLowerCase(Locale.ROOT).trim().equals("child")) {
                    professionName = nameComponents[3];
                }
                VillagerNameManager.setFirstName(entity, firstName);
                VillagerNameManager.setLastName(entity, firstName);
                VillagerNameManager.setProfessionName(professionName, entity);
            }
            if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
                if (VillagerNameManager.getLastName(entity) == null) {
                    VillagerNameManager.setLastName(entity, VillagerUtil.generateRandomSurname());
                }
            } else if (VillagerNameManager.getLastName(entity) != null) {
                VillagerNameManager.setLastName(entity, null);
            }
            entity.method_5665(VillagerNameManager.getFullNameAsText(entity, true));
            if (entity.method_7231().method_16924() == class_3852.field_17062 && !entity.method_5797().method_10851().contains(VillagerNames.CONFIG.villagerGeneralConfig.nitwitText)) {
                VillagerNameManager.setProfessionName(VillagerNames.CONFIG.villagerGeneralConfig.nitwitText, entity);
                entity.method_5665(VillagerNameManager.getFullNameAsText(entity, true));
            }
            if (!VillagerNames.CONFIG.villagerGeneralConfig.professionNames) {
                if (VillagerNameManager.getProfessionName(entity) != null) {
                    VillagerNameManager.setProfessionName(null, entity);
                }
            } else if (entity.method_7231().method_16924() != class_3852.field_17051 && !entity.method_6109()) {
                VillagerNameManager.setProfessionName(VillagerUtil.upperFirstLetter(entity.method_7231().method_16924().toString()), entity);
            }
            entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
        }
    }

    public static void createWanderingTraderNames(class_3989 entity) {
        if (!entity.method_16914() && VillagerNames.CONFIG.villagerGeneralConfig.wanderingTraderNames) {
            entity.method_5665((class_2561)new class_2585(VillagerUtil.generateWanderingTraderName() + " the " + VillagerNames.CONFIG.villagerGeneralConfig.wanderingTraderText).method_27692(VillagerNames.CONFIG.villagerGeneralConfig.villagerTextFormatting.getFormatting()));
            entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
        }
    }

    public static void updateWanderingTraderNames(class_3989 entity) {
        if (entity.method_16914() && entity.method_5797().method_10851().contains(" the ")) {
            String fullName = Objects.requireNonNull(entity.method_5797()).method_10851();
            String firstName = fullName.substring(0, fullName.indexOf(" the "));
            entity.method_5665((class_2561)new class_2585(firstName + " the " + VillagerNames.CONFIG.villagerGeneralConfig.wanderingTraderText).method_27692(VillagerNames.CONFIG.villagerGeneralConfig.villagerTextFormatting.getFormatting()));
            entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
        }
    }

    public static void updateGolemNames(class_1439 entity) {
        if (entity.method_16914()) {
            entity.method_5665((class_2561)new class_2585(Objects.requireNonNull(entity.method_5797()).method_10851()).method_27692(VillagerNames.CONFIG.villagerGeneralConfig.villagerTextFormatting.getFormatting()));
            entity.method_5880(!VillagerNames.CONFIG.villagerGeneralConfig.nameTagNames);
        }
    }

    public static void addLastNameFromBreeding(class_1646 childEntity, class_1646 parentEntity) {
        if (parentEntity.method_16914() && VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
            VillagerNameManager.setFirstName(childEntity, VillagerUtil.pickRandomName(VillagerNames.CONFIG.villagerNamesConfig));
            VillagerNameManager.setLastName(childEntity, VillagerNameManager.getLastName(parentEntity));
            childEntity.method_5665(VillagerNameManager.getFullNameAsText(childEntity, true));
        }
    }
}

